
# Create Customer Card Response

Defines the fields that are included in the response body of
a request to the `CreateCustomerCard` endpoint.

Either `errors` or `card` is present in a given response (never both).

## Structure

`CreateCustomerCardResponse`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `errors` | [`?(Error[])`](/doc/models/error.md) | Optional | Any errors that occurred during the request. | getErrors(): ?array | setErrors(?array errors): void |
| `card` | [`?Card`](/doc/models/card.md) | Optional | Represents the payment details of a card to be used for payments. These<br>details are determined by the payment token generated by Web Payments SDK. | getCard(): ?Card | setCard(?Card card): void |

## Example (as JSON)

```json
{
  "card": {
    "billing_address": {
      "address_line_1": "500 Electric Ave",
      "address_line_2": "Suite 600",
      "administrative_district_level_1": "NY",
      "country": "US",
      "locality": "New York",
      "postal_code": "10003"
    },
    "card_brand": "VISA",
    "cardholder_name": "Amelia Earhart",
    "exp_month": 11,
    "exp_year": 2018,
    "id": "icard-card_id",
    "last_4": "1111"
  }
}
```

